#include <cstdio>
#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <cmath>
#include <cassert>
#include <memory.h>
#include <queue>
#include <deque>
#include <stack>
#include <list>
#include <map>
#include <set>
#include <functional>
#include <cstring>
#include <ctime>

using namespace std;

#define all(a) a.begin(), a.end()
#define mp make_pair

typedef long long li;
typedef long double ld;
typedef pair<int, int> pi;
typedef vector<int> vi;

#define FILENAME ""

void solve();
int main() {
#ifdef YA
	string s = FILENAME;
	//assert(!s.empty());
	clock_t start = clock();
	freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#else
	//freopen(FILENAME ".in", "r", stdin);
	//freopen(FILENAME ".out", "w", stdout);
	//freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#endif
	cout.sync_with_stdio(0);
	cin.tie(0);
	cout.precision(15);
	cout << fixed;

	int t = 1;
	//cin >> t;
	while(t--) {
		solve();
	}
#ifdef YA
	cout << "\n\n" << (clock() - start) / 1.0 / CLOCKS_PER_SEC << "\n\n";
#endif
	return 0;
}


//#define int li

struct edge {
	int from, to;
	int w;
	int id;
	edge():from(-1), to(-1),w(0),id(-1){}
	edge(int from, int to, int w, int id):from(from),to(to),w(w),id(id) {}
};

int n, m;
vector <vector <edge> > g;
vector <edge> allEdges;
vector <int> good;
vector <int> bridges;

void dijkstra(int start, vector <int>& d) {
	d.assign(n, -1);
	d[start] = 0;
	priority_queue < pair <int, int>, vector <pair <int, int> >, greater < pair <int, int> > > q;
	q.push(mp(d[start], start));

	vector <int> used(n, 0);

	while (!q.empty()) {
		pair <int, int> cur = q.top();
		q.pop();
		if (used[cur.second]) {
			continue;
		}
		used[cur.second] = 0;

		int curv = cur.second;
		for (int i = 0; i < g[curv].size(); ++i) {
			if (d[g[curv][i].to] == -1 || d[g[curv][i].to] > d[curv] + g[curv][i].w) {
				d[g[curv][i].to] = d[curv] + g[curv][i].w;
				q.push(mp(d[g[curv][i].to], g[curv][i].to));
			}
		}
	}
}

int TIMER = 0;
vector <int> tin;
vector <int> tout;
vector <int> fup;

void dfs(int v, const edge& par = edge()) {
	
	++TIMER;
	fup[v] = tin[v] = TIMER;

	for (int i = 0; i < g[v].size(); ++i) {
		if (g[v][i].to == par.from) {
			continue;
		}

		if (tin[g[v][i].to] == -1) {
			dfs(g[v][i].to, g[v][i]);
			fup[v] = min(fup[g[v][i].to], fup[v]);
		}
		else {
			fup[v] = min(fup[v], tin[g[v][i].to]);
		}
	}

	if (par.from != -1 && fup[v] > tin[par.from]) {
		bridges.push_back(par.id);	
	}

	++TIMER;
	tout[v] = TIMER;
}

void solve() {
	cin >> n >> m;
	g.resize(n);
	allEdges.resize(m);
	good.assign(m, 0);
	tin.assign(n, -1);
	tout.assign(n, -1);
	fup.resize(n);
	//isBridge.assign(m, 0);

	for (int i = 0; i < m; ++i) {
		int x, y, w;
		cin >> x >> y >> w;
		--x;
		--y;
		allEdges[i] = edge(x, y, w, i);
		g[x].push_back(edge(x, y, w, i));
		g[y].push_back(edge(y, x, w, i));
	}

	vector <int> d[2];

	dijkstra(0, d[0]);
	dijkstra(n - 1, d[1]);

	for (int i = 0; i < n; ++i) {
		for (int j = 0; j < g[i].size(); ++j) {
			if (d[0][g[i][j].from] != -1 && d[1][g[i][j].to] != -1 && d[0][n - 1] == d[0][g[i][j].from] + d[1][g[i][j].to] + g[i][j].w) {
				good[g[i][j].id] = true;
			}
		}
	}

	g.clear();
	g.resize(n);
	for (int i = 0; i < m; ++i) {
		if (good[i]) {
			g[allEdges[i].from].push_back(allEdges[i]);
			swap(allEdges[i].from, allEdges[i].to);
			g[allEdges[i].from].push_back(allEdges[i]);
		}
	}

	dfs(0);
	cout << bridges.size() << "\n";
	for (int i = 0; i < bridges.size(); ++i) {
		cout << bridges[i]  + 1 << " ";
	}
}